/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.applier;

import com.ferreusveritas.dynamictrees.api.applier.Applier;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.api.applier.VoidApplier;
import javax.annotation.Nullable;

public abstract class PropertyApplier<O, V, I> {
    protected final String key;
    protected final Class<O> objectClass;
    protected final Applier<O, V> applier;

    public PropertyApplier(String key, Class<O> objectClass, VoidApplier<O, V> propertyApplier) {
        this(key, objectClass, (Applier<O, V>)propertyApplier);
    }

    public PropertyApplier(String key, Class<O> objectClass, Applier<O, V> applier) {
        this.key = key;
        this.objectClass = objectClass;
        this.applier = applier;
    }

    @Nullable
    public PropertyApplierResult applyIfShould(String key, Object object, I input) {
        if (!this.key.equalsIgnoreCase(key) || !this.objectClass.isInstance(object)) {
            return null;
        }
        return this.applyIfShould(object, input, this.applier);
    }

    @Nullable
    protected abstract PropertyApplierResult applyIfShould(O var1, I var2, Applier<O, V> var3);

    public Class<O> getObjectClass() {
        return this.objectClass;
    }
}

